;
;								EJEMPLO 19
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Introduccin al manejo del teclado.
;
;Haciendo uso de las rutinas incluidas en el fichero TECLADO.INC, se trata de leer el tecla-
;do y, visualizar sobre los leds de la puerta B el cdigo BCD de la tecla pulsada. La 
;visualizacin se mantiene estable durante dos segundos hasta una nueva pulsacin.
;
;Se trata de un ejemplo en el que la Puerta B se reconfigura dinmicamente. Inicialmente es
;configurada como salida para presentacin del resultado. Posteriormente, la rutina de 
;exploracin del teclado reconfigura RB0-RB3 como salidas y RB4-RB7 como entradas

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos
            
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
     
Key_var			equ   	0x20	;Inicio de las 6 variables empleadas por las rutinas de manejo del teclado
Delay_Cont		equ	0x26		;Variable para la temporizacin

				org	0x00		;Vector de RESET	
				goto	Inicio
				org	0x05

				include	"TECLADO.INC"	;Incluye rutinas de manejo del teclado

;*********************************************************************************
;Delay_var: Esta rutina de propsito general realiza una temporizacin variable
;entre 10 mS y 2.5". Se emplea un preescaler de 256 y al TMR0 se le carga con 39. 
;La velocidad de trabajo es de 4Mhz y por tanto el TMR0 se incrementa cada 1uS. De 
;esta forma, el TMR0 debe contar 39 eventos que, con un preescaler de 256 hace una
;intervalo total de 10000 uS (39 * 256 * 1). Este intervalo de 10 mS se repite tantes veces como 
;indique la variable "Delay_cont", es por ello que el delay mnimo es de 10 mS ("Delay_cont=1) 
;y el mximo de 2.5" (Delay_cont=255).

Delay_var:		bcf	INTCON,T0IF		;Desconecta el flag de rebosamiento
				movlw	~.39		
				movwf	TMR0		;carga el TMR0 con 39
Intervalo		btfss	INTCON,T0IF	;Rebasamiento del TMR0 ??
				goto	Intervalo	;Todava no		
				decfsz	Delay_Cont,F;Decrementa contador de intervalos
				goto	Delay_var	;Repite el intervalo de 10 mS
				return	

Inicio	       	clrf 	PORTB		;Borra los latch de salida
				bsf		STATUS,RP0	;Selecciona banco 1
				clrf	TRISB		;Puerta B se configura como salida				
				movlw	b'00000111'
				movwf	OPTION_REG	;Preescaler de 256 para el TMR0
				bcf		STATUS,RP0	;Selecciona banco 0	
		
Loop			call	Key_Scan	;Explora el teclado
				movlw	0x80
				subwf	Tecla,W
				btfsc	STATUS,Z	;Hay alguna pulsada ??
				goto	Loop		;No

				movf	Tecla,W		;Lee el cdigo de la tecla pulsada
				movwf	PORTB		;Lo visualiza sobre los leds de la Puerta B
				movlw	.200
				movwf	Delay_Cont
				call	Delay_var	;Temporiza 2 segundos
				clrf	PORTB		;Desactiva visualizacin
				goto	Loop
	
				end					;Fin del programa fuente
